﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Utilities;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace AZVIC.Ei8htPOS.WebUI.Admin.Reports
{
    public partial class BestSellersReport : System.Web.UI.Page
    {
        protected DataTable bestSellerAllTime;
        protected DataTable bestSellerLastMonth;
        protected DataTable bestSellerCurrentMonth;
        protected void Page_Load(object sender, EventArgs e)
        {
            WebSession.RedirectToAdminDashBoard(false);

            if (!IsPostBack)
            {
                BindBestSellerReport(DateTime.MinValue, DateTime.MinValue);
            }
        }

        protected void btnExportToExcel(object sender, EventArgs e)
        {
            BindBestSellerReport(DateTime.MinValue, DateTime.MinValue);
            Master.ExportToExcel<Entities.Promotion>(grdBestSellers, "BestSellersReport");
        }

        private void BindBestSellerReport(DateTime fromDate, DateTime toDate)
        {
            bestSellerAllTime = ReportsBL.GetTop20Products(fromDate, toDate);
            grdBestSellers.DataSource = bestSellerAllTime;
            grdBestSellers.DataBind();
            
            rpBSAllTime.DataSource = bestSellerAllTime;
            rpBSAllTime.DataBind();
            
            bestSellerCurrentMonth = ReportsBL.GetTop20Products(new DateTime( DateTime.Now.Year,DateTime.Now.Month,1 ), DateTime.Now);
            rpBSItemCurrentMonth.DataSource=bestSellerAllTime;
            rpBSItemCurrentMonth.DataBind();
            lblCurrentMonth.Text = DateTime.Now.ToString("MMMMM-yyyy");
            lblLastMonth.Text = DateTime.Now.AddMonths(-1).ToString("MMMMM-yyyy");

            DateTime PreviousMonth = new DateTime(DateTime.Now.AddMonths(-1).Year,DateTime.Now.AddMonths(-1).Month,1);
            bestSellerLastMonth=ReportsBL.GetTop20Products(PreviousMonth, new DateTime(PreviousMonth.Year,PreviousMonth.Month,DateTime.DaysInMonth(PreviousMonth.Year,PreviousMonth.Month)));
            rpBSItemsLastMonth.DataSource=bestSellerLastMonth;
            rpBSItemsLastMonth.DataBind();

            

            


            if (bestSellerAllTime.Rows.Count == 0)
                WebUtilities.ShowMessage(this, "No Products found");
        }

        protected void grdBestSellers_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            grdBestSellers.PageIndex = e.NewPageIndex;
            BindBestSellerReport((string.IsNullOrEmpty(txtFromDate.Text.Trim()) ? DateTime.MinValue : DateTime.ParseExact(txtFromDate.Text.Trim(), "dd/MM/yyyy", null)),
                                 (string.IsNullOrEmpty(txtToDate.Text.Trim()) ? DateTime.MinValue : DateTime.ParseExact(txtToDate.Text.Trim(), "dd/MM/yyyy", null)));
        }

        protected void btnSearch_Click(object sender, EventArgs e)
        {
            if (txtFromDate.Text.Trim().Length != 0 && !ValidationUtility.ValidateDate(txtFromDate.Text.Trim(), "dd/MM/yyyy"))
            {
                WebUtilities.ShowMessage(this, "Please select valid From Date");
                return;
            }

            if (txtToDate.Text.Trim().Length != 0 && !ValidationUtility.ValidateDate(txtToDate.Text.Trim(), "dd/MM/yyyy"))
            {
                WebUtilities.ShowMessage(this, "Please select valid To Date");
                return;
            }

            BindBestSellerReport((string.IsNullOrEmpty(txtFromDate.Text.Trim()) ? DateTime.MinValue : DateTime.ParseExact(txtFromDate.Text.Trim(), "dd/MM/yyyy", null)),
                                 (string.IsNullOrEmpty(txtToDate.Text.Trim()) ? DateTime.MinValue : DateTime.ParseExact(txtToDate.Text.Trim(), "dd/MM/yyyy", null)));
        }

        protected void btnShowAll_Click(object sender, EventArgs e)
        {
            BindBestSellerReport(DateTime.Now, DateTime.Now);
        }
    }
}